# Copyright (C) 2013-2019 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 17-Aug-2019 06:56.

"""DspSPcontroller userdefined profile, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.switch
import izot.resources.datapoints.press_p
import izot.resources.datapoints.lev_percent
import izot.resources.datapoints.count
import izot.resources.datapoints.str_asc
import P9000010600000000_4.datapoints.devHandle
import izot.resources.properties.delayTime
import izot.resources.properties.ductStaticPressureSetpoint
import izot.resources.properties.maxDuctStaticPressureSetpoint
import izot.resources.properties.minDuctStaticPressureSetpoint
import izot.resources.properties.measurementInterval


class DspSPcontroller(izot.resources.base.Profile):
    """DspSPcontroller userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20004,
            scope=4
        )
        self.datapoints['nviEnable'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch Enables controller after delay expirtes.""",
            name='nviEnable',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.switch.switch,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoDspSP'] = izot.resources.base.Profile.DatapointMember(
            doc="""Pressure (gauge) The demand calculated duct static
            pressure setpoint subject to limits.""",
            name='nvoDspSP',
            profile=self,
            number=2,
            datatype=izot.resources.datapoints.press_p.press_p,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoMaxDemand'] = izot.resources.base.Profile.DatapointMember(
            doc="""Percentage level.  Level percent.  SNVT_switch should be
            used instead of SNVT_lev_percent, with the exception of network
            variables that are used to communicate a percentage value and
            that require the additional resolution provided by
            SNVT_lev_percent;  or for network variable members of functional
            profiles that are designed primarily for interfacing with
            SNVT_lev_percent members of other profiles.""",
            name='nvoMaxDemand',
            profile=self,
            number=3,
            datatype=izot.resources.datapoints.lev_percent.lev_percent,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoMinDemand'] = izot.resources.base.Profile.DatapointMember(
            doc="""Percentage level.  Level percent.  SNVT_switch should be
            used instead of SNVT_lev_percent, with the exception of network
            variables that are used to communicate a percentage value and
            that require the additional resolution provided by
            SNVT_lev_percent;  or for network variable members of functional
            profiles that are designed primarily for interfacing with
            SNVT_lev_percent members of other profiles.""",
            name='nvoMinDemand',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.lev_percent.lev_percent,
            mandatory=True,
            minimum=b'\x68\xe8',
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoAvgDemand'] = izot.resources.base.Profile.DatapointMember(
            doc="""Percentage level.  Level percent.  SNVT_switch should be
            used instead of SNVT_lev_percent, with the exception of network
            variables that are used to communicate a percentage value and
            that require the additional resolution provided by
            SNVT_lev_percent;  or for network variable members of functional
            profiles that are designed primarily for interfacing with
            SNVT_lev_percent members of other profiles.""",
            name='nvoAvgDemand',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.lev_percent.lev_percent,
            mandatory=True,
            minimum=b'\x90\xf0',
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoRougeCount'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  The number of designated rouge VAVs.""",
            name='nvoRougeCount',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviAddRouge'] = izot.resources.base.Profile.DatapointMember(
            doc="""Character string (30 characters max) Used to add a VAV
            device handle to the Rouge list.  Rouges are not used in control
            sequence.""",
            name='nviAddRouge',
            profile=self,
            number=7,
            datatype=izot.resources.datapoints.str_asc.str_asc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviRemoveRouge'] = izot.resources.base.Profile.DatapointMember(
            doc="""Character string (30 characters max) Used to remove a VAV
            device handle to the Rouge list.""",
            name='nviRemoveRouge',
            profile=self,
            number=8,
            datatype=izot.resources.datapoints.str_asc.str_asc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviShowRouge'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  The index to the rouge list.  Zero
            based.""",
            name='nviShowRouge',
            profile=self,
            number=9,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoRougeReport'] = izot.resources.base.Profile.DatapointMember(
            doc=""" Reports the Index, and the handle of the last requested
            nviShowRouge request.""",
            name='nvoRougeReport',
            profile=self,
            number=10,
            datatype=P9000010600000000_4.datapoints.devHandle.devHandle,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['cpDelay'] = izot.resources.base.Profile.PropertyMember(
            doc="""Delay time, default to scene.  The delay time, default to
            scene.""",
            name='cpDelay',
            profile=self,
            number=1,
            datatype=izot.resources.properties.delayTime.delayTime,
            default=b'\x03\x84',
            mandatory=True
        )
        self.properties['cpDefaultDspSP'] = izot.resources.base.Profile.PropertyMember(
            doc="""Duct static pressure.  Setpoint for default duct static
            pressure.""",
            name='cpDefaultDspSP',
            profile=self,
            number=2,
            datatype=izot.resources.properties.ductStaticPressureSetpoint.ductStaticPressureSetpoint,
            default=b'\x01\xf4',
            mandatory=True
        )
        self.properties['cpMaxDspSP'] = izot.resources.base.Profile.PropertyMember(
            doc="""Maximum duct static pressure.  Setpoint for maximum duct
            static pressure.""",
            name='cpMaxDspSP',
            profile=self,
            number=3,
            datatype=izot.resources.properties.maxDuctStaticPressureSetpoint.maxDuctStaticPressureSetpoint,
            default=b'\x02\xeb',
            mandatory=True
        )
        self.properties['cpMinDspSP'] = izot.resources.base.Profile.PropertyMember(
            doc="""Minimum duct static pressure.  Setpoint for minimum duct
            static pressure.""",
            name='cpMinDspSP',
            profile=self,
            number=4,
            datatype=izot.resources.properties.minDuctStaticPressureSetpoint.minDuctStaticPressureSetpoint,
            default=b'\x00\xf9',
            mandatory=True
        )
        self.properties['cpLoopInterval'] = izot.resources.base.Profile.PropertyMember(
            doc="""Measurement interval.  Time period used for a
            measurement.""",
            name='cpLoopInterval',
            profile=self,
            number=5,
            datatype=izot.resources.properties.measurementInterval.measurementInterval,
            default=b'\x00\x96',
            mandatory=True
        )
        self._original_name = 'UFPTDspSPcontroller'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = DspSPcontroller()
    pass
